//
//  Handling_Event_Changed_NotificationsAppDelegate.m
//  Handling Event Changed Notifications
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Handling_Event_Changed_NotificationsAppDelegate.h"

@implementation Handling_Event_Changed_NotificationsAppDelegate

@synthesize window = _window;
@synthesize eventsForOneYear;
@synthesize eventStore;

- (EKCalendar *) 
    calDAVCalendarWithTitleContaining:(NSString *)paramDescription
                         inEventStore:(EKEventStore *)paramEventStore{
  
  EKCalendar *result = nil;
  
  for (EKCalendar *thisCalendar in paramEventStore.calendars){
    if (thisCalendar.type == EKCalendarTypeCalDAV){
      if ([thisCalendar.title 
           rangeOfString:paramDescription].location != NSNotFound){
        return thisCalendar;
      }
    }
  }
  
  return result;
  
}

- (void) eventsChanged:(NSNotification *)paramNotification{
  
  NSMutableArray *invalidatedEvents = [[NSMutableArray alloc] init];
  
  NSLog(@"Odświeżanie zawartości tablicy wydarzeń...");
  
  for (EKEvent *event in self.eventsForOneYear){
    if ([event refresh] == NO){
      [invalidatedEvents addObject:event];
    }
  }
  
  if ([invalidatedEvents count] > 0){
    [self.eventsForOneYear removeObjectsInArray:invalidatedEvents];
  }
  
}

- (BOOL)            application:(UIApplication *)application
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  self.eventStore = [[EKEventStore alloc] init];
  
  EKCalendar *calendar = 
  [self calDAVCalendarWithTitleContaining:@"vandad.np@gmail.com"
                             inEventStore:self.eventStore];
  
  NSTimeInterval NSOneYear = 1 * 365 * 24 * 60 * 60;
  
  NSDate *startDate = [NSDate date];
  NSDate *endDate = [startDate dateByAddingTimeInterval:NSOneYear];
  
  NSArray *calendars = [[NSArray alloc] initWithObjects:calendar, nil];
  
  NSPredicate *predicate = 
  [self.eventStore predicateForEventsWithStartDate:startDate
                                           endDate:endDate
                                         calendars:calendars];
  
  NSArray *events = [self.eventStore eventsMatchingPredicate:predicate];
  
  self.eventsForOneYear = [[NSMutableArray alloc] initWithArray:events];
  
  [[NSNotificationCenter defaultCenter] 
   addObserver:self
   selector:@selector(eventsChanged:)
   name:EKEventStoreChangedNotification
   object:nil];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
